<?php

namespace App\Models\Lap;

use CodeIgniter\Model;

class BMSiswaModel extends Model
{
    protected $table = 'tb_siswa';
    protected $primaryKey = 'id_siswa';
    protected $returnType = 'array';

    protected $allowedFields = [
        'nis',
        'nama_siswa',
        'id_kelas',
        'jenis_kelamin',
        'no_hp',
        'unique_code'
    ];

    /**
     * =============================
     * TOTAL SISWA
     * =============================
     */
    public function totalSiswa()
    {
        return $this->countAllResults();
    }

    /**
     * =============================
     * SEMUA SISWA + KELAS
     * =============================
     */
    public function getSiswa()
    {
        return $this->db->table('tb_siswa s')
            ->select('
                s.id_siswa,
                s.nis,
                s.nama_siswa,
                s.jenis_kelamin,
                k.kelas
            ')
            ->join('tb_kelas k', 'k.id_kelas = s.id_kelas', 'left')
            ->orderBy('s.nama_siswa', 'ASC')
            ->get()
            ->getResultArray();
    }

    /**
     * =============================
     * SISWA + KELAS (FILTER KELAS / ALL)
     * DIPAKAI LAPORAN & EXPORT
     * =============================
     */
    public function getSiswaWithKelas($idKelas = null)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('
                s.id_siswa,
                s.nis,
                s.nama_siswa,
                s.jenis_kelamin,
                s.id_kelas,
                k.kelas AS nama_kelas
            ')
            ->join('tb_kelas k', 'k.id_kelas = s.id_kelas', 'left');

        if ($idKelas && $idKelas !== 'all') {
            $builder->where('s.id_kelas', $idKelas);
        }

        return $builder
            ->orderBy('k.kelas', 'ASC')
            ->orderBy('s.nama_siswa', 'ASC')
            ->get()
            ->getResultArray();
    }

    /**
     * =============================
     * SEMUA SISWA (ALIAS)
     * =============================
     */
    public function getAllSiswa()
    {
        return $this->getSiswaWithKelas();
    }

    /**
     * =============================
     * SISWA BERDASARKAN KELAS
     * =============================
     */
    public function getSiswaByKelas($id_kelas = null)
    {
        return $this->getSiswaWithKelas($id_kelas);
    }
}
